//USE THESE TO CUSTOMISE THE TREE

var DEBUG = 1;
var kSelectable = "on"; 
var kmsgSelect = " unselectable='" + kSelectable + "'";
var kmsgUnselect = " unselectable='off'";
//locale messages

/********************************************************************************************/

var tTreeImageMap = new Array();

// this function expects an even number of arguments
// refpath, virtpath, refpath, virtpath ...

function TreeImageMapAdd()
{
   var aArguments = TreeImageMapAdd.arguments;

   var i = 0;
   while (i < aArguments.length)
   {
      key = aArguments[i++];
      key = key.toLowerCase(); 
      value=aArguments[i++];
      tTreeImageMap[key] = value;
   }
}

function TreeImageMapGet(sKey)
{
   var lower = sKey.toLowerCase();
   return tTreeImageMap[lower];
   
}

saw.sawtree = function(){};

var sawtree = saw.sawtree;


sawtree.init = function ()
{

   this.onclickMethodTable = new Object();
   this.ondblclickMethodTable = new Object();
   this.treeViewTable = new Array();
   this.itemTable = new Array();
   this.nItems = 0;   
   this.clickedItemId = "";
   this.initMethodTable();
   sawtree.lastClickedNameFolder = null;

   return this;
}



/********************************************************************************************/
sawtree.debug = function (str)
{
   if (DEBUG)
      alert(str);
}

/********************************************************************************************/
sawtree.addOnclickMethod = function addOnclickMethod (name, funct)
{
   if (funct) 
      sawtree.onclickMethodTable[name] = funct;
}

/********************************************************************************************/
sawtree.addOndblclickMethod = function addOndblclickMethod (name, funct)
{
   if (funct) 
      sawtree.ondblclickMethodTable[name] = funct;
}

/********************************************************************************************/
sawtree.getOnclickMethod = function  (name)
{
   var func = sawtree.onclickMethodTable[name];
   return func;
}

/********************************************************************************************/
sawtree.getOndblclickMethod = function  (name)
{
   var func = sawtree.ondblclickMethodTable[name];
   return func;
}


sawtree.sendAjaxReq = function (url, headArray, sendMethod, content, processMethod) 
{
   var req = new sawr.serverRequest(url, processMethod);
   req.setFatalErrorHandler(sawtree.handleServerError);
   
   var conn = new sawr.xhrConnection(req);

   var len  = 0;
   if(headArray)
      len = headArray.length;
   var i = 0;
   for (; i < len; ++i)
   {
      req.addArg(headArray[i].name, headArray[i].value);
   }

   if (sendMethod == "post" || sendMethod == "POST")
      conn.post();
   else
      conn.get();         

}




/********************************************************************************************/
sawtree.parseCustomData = function parseCustomData (dataElem, item)
{
   var i =0;
   
   for(; i< dataElem.childNodes.length;++i)
   {
      
      var data = dataElem.childNodes[i];
      if (data.nodeName != "data")
         continue;
      var name = data.getAttribute("name");
      var value = data.getAttribute("value");
      item[name] = value;
   }
}


/********************************************************************************************/
sawtree.clickOnFolder = function (folderId, event) 
{ 
  var clicked = sawtree.findItem(folderId);


  var sElement = null;
  if (event)
    sElement = window.saw.getEventTarget(event);
  
  if (typeof clicked=='undefined' || clicked==null)
  {
    sawtree.error("Treeview was not able to find the node object corresponding to ID=" + folderId + ". If the configuration file sets a.xID values, it must set them for ALL nodes, including the foldersTree root.")
    return;
  }

   if (!clicked.isOpen() || event == null || sElement.id == (clicked.getEleImageId()))
      clicked.toggleFolder();


   //if user click on the name of the folder, then the user clicks on the sibling folder, then the last folder will be close
   if (sElement && sElement.id != (clicked.getEleImageId()))
   {
   
      if (sawtree.lastClickedNameFolder)
      {
         var explorerStyle = sawtree.lastClickedNameFolder.getAttributeValue("explorerStyle");
         if (sawtree.lastClickedNameFolder.parentObj == clicked.parentObj && sawtree.lastClickedNameFolder.isOpen() && sawtree.lastClickedNameFolder != clicked &&  explorerStyle != "false")
            sawtree.lastClickedNameFolder.toggleFolder();
      }
            
      sawtree.lastClickedNameFolder = clicked;
   }
   
   if (clicked.isOpen() && !clicked.isLoaded())
   {
      clicked.loadBranch(clicked);
   }
} 

/********************************************************************************************/ 

sawtree.clickOnFolderAnswer = function clickOnFolderAnswer(itemId, event)
{
   var item = sawtree.findItem(itemId);
   AnswersEntry(item.path, null, null, event, item.getDisplayName());
   sawtree.clickOnFolder(itemId, event);
}

/********************************************************************************************/
sawtree.clickOnItemAnswer = function clickOnItemAnswer (itemId, event)
{
   var item = sawtree.findItem(itemId);
   AnswersEntryPreview(item.path, event);
}



/********************************************************************************************/
sawtree.clickOnItemSubject = function clickOnItemSubject (itemId, event)
{
   var item = sawtree.findItem(itemId);

   var column = NQWCreateColumn(tPickerSA, item.reference, item.tableHeading, item.columnHeading, "locale", item.SQLType, item.AggType, item.AggRule, item.category, item.columnWidth, 
                                 item.dataTZOffset, item.displayDefaultTZOffset, item.displayDefaultTZ);
   
   NQWAddToTable(column, event);

}

/********************************************************************************************/
sawtree.clickOnFilterSubject = function clickOnFilterSubject(itemId, event)
{
   var item = sawtree.findItem(itemId);
   TreeLoadSavedFilter(item.path);
}

/********************************************************************************************/
sawtree.createFolderIn = function (name, path, elemId)
{
   var parentElem = sawtree.findItem(elemId);
   var folder = null;
   
   var itemId  = -1;
   if (parentElem)
   {
      // Insert new folder alphabetically within child list of existing folders
      folder = new sawtree.Folder(name, name, parentElem, path, "folder", -1);
      parentElem.redrawChildren();
   }
   //assume the owner has write access
   if (folder)
   {
      folder.writeAccess = true;
      //folder.m_bIsOpen = true;
      folder.m_bIsLoaded = true;
      itemId = folder.getID();
   }
   return itemId;
}


sawtree.clickedItem1 = function(itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   var bWrite = item.getAttributeValue("writeAccess");
   var bAccessRequired = item.getAttributeValue("accessRequired");
   
   if (bAccessRequired != "true" || bWrite == "true")      
   {
       sawtree.selectItem(itemId, item.getPath()); 
   }
}


sawtree.clickedSavedItem = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   var bWrite = item.getAttributeValue("writeAccess");
   var bAccessRequired = item.getAttributeValue("accessRequired");

   if (bAccessRequired != "true" || bWrite == "true")      
   {
      var folderPath = item.parentObj ? item.parentObj.getPath() : item.getPath();
      
      sawtree.selectItem(itemId, folderPath);
      CatalogBrowser.selectItemName('idBrowser', item.getName());
   }
}

sawtree.clickonDeliversFolder = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onCatalogFolderClick(item.getPath(), event);
      sawtree.clickOnFolder(item.id, event);
   }
}

sawtree.clickonDeliversBriefingBook = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onBriefingBookClick(item.getPath(), event);
   }
}

sawtree.clickonDeliversDashboardPage = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onDashboardPageClick(item.getPath());
   }
}

sawtree.clickonDeliversCondition = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onConditionClick(item.getPath());
   }
}

sawtree.clickonDeliversIBotFolder = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onIBotFolderClick(item.getPath());
      sawtree.clickOnFolder(itemId, event);
   }
}

sawtree.clickonDeliversReport = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onReportClick(item.getPath());
   }
}

sawtree.clickonDeliversIBot = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onIBotClick(item.getPath());
   }
}


sawtree.clickonDeliversDisconnectedDataset = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.onDisconnectedDatasetClick(item.getPath());
   }
}

sawtree.clickonDashboard = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      DashboardPreview(item.getPath(), event);
      sawtree.clickOnFolder(item.id, event);
   }
}

sawtree.clickonBriefbookItem = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      BriefBookProps(item.getPath());
   }
}

sawtree.clickonAdvancedReportItem = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      var tFrame = (parent.queryFrame) ? parent.queryFrame : parent; 
      if (tFrame.NQWAdvancedReportSelected)
         tFrame.NQWAdvancedReportSelected(item.getPath(), 0, event);
   }
}

sawtree.clickonAdvancedReportItemVersion = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      var tFrame = (parent.queryFrame) ? parent.queryFrame : parent; 
      if (tFrame.NQWAdvancedReportSelected)
         tFrame.NQWAdvancedReportSelected(item.getPath(), 0, event);
   }
   
   sawtree.clickOnFolder(itemId, event);   
}

sawtree.clickonAdvancedReportVersionedItem = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      var tFrame = (parent.queryFrame) ? parent.queryFrame : parent; 
      if (tFrame.NQWAdvancedReportSelected)
         tFrame.NQWAdvancedReportSelected(item.getPath(), item.getXPath(), event);
         
      if (item.isSelectable())
         sawtree.selectItem(itemId, item.getPath());              
   }
}

sawtree.clickonAdvancedReportFolder = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      var tFrame = (parent.queryFrame) ? parent.queryFrame : parent; 
      if (tFrame.NQWAdvancedReportFolderSelected)
         tFrame.NQWAdvancedReportFolderSelected(item.getPath(), event);
   }
   
   sawtree.clickOnFolder(itemId, event);
}


sawtree.clickonAnswers = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
      Answers(item.getPath());
}


sawtree.clickOnWorksheetItem = function (itemId, event)
{
   var item = sawtree.findItem(itemId);
   
   if (item)
   {
      saw.browserId = "idWorksheetObjectPickerDlg";
      sawtree.selectItem(itemId, item.getPath()); 
      var tFrame = (parent.queryFrame) ? parent.queryFrame : parent; 
      if(tFrame.WorksheetObjectPickerEditor)
         tFrame.WorksheetObjectPickerEditor.setTarget("idWorksheetObjectPickerDlg", item.getPath(), item.getDisplayPath(), event);
   }   
}

/********************************************************************************************/
sawtree.initMethodTable = function ()
{
   sawtree.addOnclickMethod("clickedItem", sawtree.clickedItem1);
   sawtree.addOnclickMethod("clickedItem1", sawtree.clickedItem1);
   sawtree.addOnclickMethod("clickedSavedItem", sawtree.clickedSavedItem);
   sawtree.addOnclickMethod("clickonAnswers", sawtree.clickonAnswers);
   sawtree.addOnclickMethod("clickonDashboard", sawtree.clickonDashboard);
   sawtree.addOnclickMethod("clickOnFilterSubject", sawtree.clickOnFilterSubject);
   sawtree.addOnclickMethod("clickOnItemSubject", sawtree.clickOnItemSubject);
   sawtree.addOnclickMethod("clickOnItemAnswer", sawtree.clickOnItemAnswer);
   sawtree.addOnclickMethod("clickOnFolder", sawtree.clickOnFolder);
   sawtree.addOnclickMethod("clickOnFolderAnswer", sawtree.clickOnFolderAnswer);
   sawtree.addOnclickMethod("clickonBriefbookItem", sawtree.clickonBriefbookItem);
   sawtree.addOnclickMethod("clickonAdvancedReportItem", sawtree.clickonAdvancedReportItem);
   sawtree.addOnclickMethod("clickonAdvancedReportFolder", sawtree.clickonAdvancedReportFolder);
   sawtree.addOnclickMethod("clickonAdvancedReportItemVersion", sawtree.clickonAdvancedReportItemVersion);
   sawtree.addOnclickMethod("clickonAdvancedReportVersionedItem", sawtree.clickonAdvancedReportVersionedItem);
   sawtree.addOnclickMethod("clickonDeliversFolder", sawtree.clickonDeliversFolder);
   sawtree.addOnclickMethod("clickonDeliversReport", sawtree.clickonDeliversReport);
   sawtree.addOnclickMethod("clickonDeliversBriefingBook", sawtree.clickonDeliversBriefingBook);
   sawtree.addOnclickMethod("clickonDeliversDashboardPage", sawtree.clickonDeliversDashboardPage);
   sawtree.addOnclickMethod("clickonDeliversIBotFolder", sawtree.clickonDeliversIBotFolder);
   sawtree.addOnclickMethod("clickonDeliversIBot", sawtree.clickonDeliversIBot);
   sawtree.addOnclickMethod("clickonDeliversDisconnectedDataset", sawtree.clickonDeliversDisconnectedDataset);
   sawtree.addOnclickMethod("clickonDeliversCondition", sawtree.clickonDeliversCondition);
   sawtree.addOnclickMethod("clickOnWorksheetItem", sawtree.clickOnWorksheetItem);
}


/********************************************************************************************/

sawtree.SawTreeView = function SawTreeView() 
{
   this.treeList = new Array ();   
   this.bInit = false;
   this.initElementName = null;
   this.initText = "";
   //methods
   this.clickedId = null;
   this.clickedObject = null;

   return this;
}

sawtree.SawTreeView.prototype.reset = function ()
{
   this.initText = "";
   var object = document.getElementById(this.initElementName);
   if (object)
      object.innerHTML = "";
   this.treeList = new Array();
   this.bInit = false;
}


/********************************************************************************************/
//initText is a xml document in JavaScript string format
function initSawTreeView(initText, insertObj)
{

   if (!initText)
      return;

   if(!insertObj || typeof insertObj == 'undefined'  )
      insertObj = null;

   var xmlDoc = saw.getXmlIsland ("xml", null, initText);
   
   xmlDoc.loadXML(initText);
   initTreeView(xmlDoc, insertObj);
   sawtree.initText = initText;
      
}

/********************************************************************************************/      
function initTreeView (xmlDoc, insertObj)
{

   var insertElementId = "";
   var requestXml = xmlDoc.selectSingleNode("//request");
   if (requestXml)
      insertElementId = requestXml.getAttribute("insertElementId");
   else
   {  
      alert("requestXml is not found");
   }

   var treesElem = xmlDoc.selectSingleNode('//trees');
   var treeElem = null;
   var treeType = null;
   var i = 0;
      
   var obj = insertObj;
   if (obj == null)
   {
      obj = document.getElementById(insertElementId);
   }
   
   if (obj == null)
      obj = document.getElementById("idBrowserHolderDiv");
   
   if (obj == null)
      return;   
   obj.innerHTML = "";
   
   var position = requestXml.getAttribute("insertPosition");
   var sawTreeView = null;
   var j = 0; 
   
   for(j=0; j<sawtree.treeViewTable.length;++j)
   {
      var tTreeView = sawtree.treeViewTable[j];
      if(tTreeView.initElementName == insertElementId && tTreeView.initText == xmlDoc)
      {
         sawTreeView = tTreeView;
      }
   }
  
   
   if (sawTreeView == null)
      sawTreeView  = new sawtree.SawTreeView();
   else
   {
      for (i=0; i < sawTreeView.treeList.length; ++i)
      {
         var tree = sawTreeView.treeList[i];
         var sHtml = tree.renderObject();
         
         if (obj)
            obj.insertAdjacentHTML(position, sHtml);
      }
   
      return;
   }
   
   sawTreeView.initText = xmlDoc;
   
   sawTreeView.initElementName = insertElementId;
   sawtree.treeViewTable[sawtree.treeViewTable.length] = sawTreeView;
   

   if (position == null)
      position = "beforeEnd";
     
   
   for (i = 0; i < treesElem.childNodes.length; ++i)
   {
      if (treesElem.childNodes[i].nodeType != 1)
         continue;
      if (treesElem.childNodes[i].nodeName != "tree")
         continue;
         
      treeElem = treesElem.childNodes[i];
      var j = 0;
      var treeDef = null;
            
      for (; j < treeElem.childNodes.length; ++j)
      {
         if(treeElem.childNodes[j].nodeType != 1) 
            continue;
         var element = treeElem.childNodes[j];
         
         if (element.nodeName == "treeDef")
         {
            treeDef = new sawtree.TreeDef();
            treeDef.treeView = sawTreeView;
            treeType = element.getAttribute("treeType");
            treeDef.treeType = treeType;
            treeDef.parseXmlClassDef (element);
            treeDef.subjectArea = element.getAttribute("subjectArea");
         }
         else if (element.nodeName == "treeData")
         {
            sawtree.loadtree(element, null, treeDef);
         }
      }
   }

   for (i=0; i < sawTreeView.treeList.length; ++i)
   {
      var tree = sawTreeView.treeList[i];
      
      var sHtml = "";
      var startHtml = tree.getAttributeValue("startHtml");
      if(startHtml)
         sHtml = startHtml;
      
      sHtml += tree.renderObject();
      
      if (obj)
         obj.insertAdjacentHTML(position, sHtml);
   }
} 



/********************************************************************************************/
sawtree.TreeDef = function ()
{

   this.treeRoot = null;
   this.title;
   this.treeDefName = "";
   this.folderDef = null;
   this.leafDef = null;
   this.displayEmpty = true;
   this.tableClass = null;
   this.xmlElement = null;
}

/********************************************************************************************/

sawtree.TreeDef.prototype.createNode = function (itemName, signature, itemType, path, parentNode)
{
   var object = null;
   var className = "";
   
   if (!signature)
      className = "folder";
   else
      className = signature;
      

   var classDef = this.tableClass.getClass(className);
   var objectType = null;
   if (classDef)
      objectType = classDef.getItemType();
   else
      objectType = itemType;
      
   if (objectType == "folder")
   {
      object = sawtree.Folder(itemName, itemType, parentNode, path, signature);
   }
   else 
   {
      object = sawtree.Item(itemName, itemType, parentNode, path, signature);
   }

   object.htmlData = classDef;
   
   return object;
}

/********************************************************************************************/

sawtree.TreeDef.prototype.addChildClass = function (parentClass, typesElm, itemType)
{
   var i = 0;
   for (; i < typesElm.childNodes.length; ++i)
   {
      var elem = typesElm.childNodes[i];
      var typeName = elem.getAttribute("name");
      var treeType = elem.getAttribute("type");
      var classDef = new sawtree.ClassDefinition();
      classDef.init(typeName, itemType, treeType, parentClass, elem);
      this.tableClass.addClass(typeName, classDef);
   }

}
/********************************************************************************************/


sawtree.TreeDef.prototype.initObjectClass = function (item, className)
{
   if (!className)
      className = "folder";
   var classDef = this.tableClass.getClass(className);
   item.htmlData = classDef;
}

/********************************************************************************************/

sawtree.TreeDef.prototype.parseXmlClassDef = function (xmlElm)
{

   var tExp = xmlElm.getAttribute("expanded");
   var tEmpty = xmlElm.getAttribute("displayEmpty");
   
   this.xmlElement = xmlElm;
   if (tEmpty)
      this.displayEmpty = false;
      
   var treeClass = new sawtree.ClassDefinition();
   var rootClass = new sawtree.ClassDefinition();
   var folderClass = new sawtree.ClassDefinition();
   var leafClass = new sawtree.ClassDefinition;

   this.tableClass = new sawtree.ObjectDef ();
   var rootTreeType = xmlElm.getAttribute("type");

   this.treeDefName = xmlElm.getAttribute("treeDef");
   
   var treeElm = xmlElm.selectSingleNode("treeDef");
   this.startHtml = xmlElm.getAttribute("startHtml");
   var folderElm = xmlElm.selectSingleNode("folderDef");
   treeClass.init("treeClass", "tree", "", null, treeElm);
   folderClass.init("folderClass", "folder", "", treeClass, folderElm);
   rootClass.init ("rootClass", "folder", rootTreeType, folderClass, xmlElm);
   
   this.tableClass.addClass("treeClass", treeClass);
   this.tableClass.addClass("rootClass", rootClass, "folder");     
   this.tableClass.addClass("folderClass", folderClass);
   var typesElm = folderElm.selectSingleNode("types");
   
   this.addChildClass(folderClass, typesElm, "folder");
   
   var leafElm = xmlElm.selectSingleNode("leafDef");
   leafClass.init("leafClass", "item", "", treeClass, leafElm);
   this.tableClass.addClass("leafClass", leafClass);
   typesElm = leafElm.selectSingleNode("types");
   
   this.addChildClass(leafClass, typesElm, "item");
   
}

/********************************************************************************************/
sawtree.TreeDef.prototype.parseTreeDef = function parseTreeDef (xmlElm, treeDef)
{
   var title = xmlElm.getAttribute("titleMsg");
   var rootImg = xmlElm.getAttribute("rootImg");
   var bOpen = false;
   treeDef.folderDef = new sawtree.ObjectDef();
   treeDef.rootImg = rootImg;
   treeDef.title = title;
   var tExp = xmlElm.getAttribute("expanded");

   var treeName = xmlElm.getAttribute("treeDef");
   treeDef.treeName = treeName;
   if (tExp)
      treeDef.bIsOpen = true;

   var folderElm = xmlElm.selectSingleNode("folderDef");
   if(folderElm)
      treeDef.folderDef.parseObjectDef(folderElm, treeDef.folderDef);
   
   treeDef.leafDef  = new sawtree.ObjectDef();
   var leafElm = xmlElm.selectSingleNode("leafDef");
   if(leafElm)
      treeDef.leafDef.parseObjectDef(leafElm, treeDef.leafDef);
   
}


/********************************************************************************************/



/********************************************************************************************/
sawtree.SawTreeView.prototype.addTree = function (tree) 
{
//tree is the root of the tree
   var i;
   var len = this.treeList.length;
   var obj;
   for (i = 0; i < len; ++i)
   {  
      obj = this.treeList[i];
      if (obj != null && obj.displayName == tree.disPlayname && obj.path == tree.path)
         return null;
   }
   
   this.treeList[len] = tree;
   return tree;
}
/********************************************************************************************/
sawtree.TreeNode = function TreeNode () //constructor 
{ 
   //Server data 
  this.name = "";
  this.displayName = ""; 
  this.path = "";
  
  //html data

  this.m_bSelectable = false;
  //dynamic structural data
  this.htmlData = null;
  this.id = -1;
  this.children = null;
  this.nChildren = 0;
  this.level = 0;
  this.parentObj = null;  
  
  this.onClickMethod = null;
  this.onDblClickMethod = null;
  //state data 
  this.m_bIsOpen = false;
  this.m_bIsLastOpenedFolder = false;
  this.m_bIsRendered = false;
  this.m_bIsLoaded = false;
  
} 
/********************************************************************************************/


sawtree.TreeNode.prototype.getAttributeValue = function (attributeName)
{
   var value = null;
   value = this[attributeName];
   
   if (value)
      return value;
      
   if (this.htmlData)
      return this.htmlData.getAttributeValue(attributeName);
   else
      return "";
}

sawtree.TreeNode.prototype.getTreeType = function ()
{
   return this.getAttributeValue("treeType");
}

sawtree.TreeNode.prototype.getType = function ()
{
   return "node";
}

sawtree.TreeNode.prototype.setDragXml = function ()
{
   if (tTreeXmlArray)
      tTreeXmlArray[this.getTreeXmlId()]= this.getDragXml();
}

sawtree.TreeNode.prototype.getTreeXmlId = function ()
{
   return "drag" + this.getEleNodeId();
}
   
sawtree.TreeNode.prototype.getDragXml = function ()
{
   return this.dragXml;
}

sawtree.TreeNode.prototype.getToolTip = function ()
{
    if (this.description)
        return this.description;
    else
        return this.getDisplayName();
}

sawtree.TreeNode.prototype.getDictURL = function ()
{
   return this.dictURL;
}

sawtree.TreeNode.prototype.getSignature = function ()
{
   if (this.isFolder())
      return this.getType();
   else 
      return this.signature;
}

sawtree.TreeNode.prototype.init = function (name, path, parentNode, signature, insertPos)
{
   this.name = name;
   this.path = path;
   this.parentObj = parentNode;
   this.signature = signature;
   sawtree.addItemTable(this);
    
   if (parentNode == null)
      this.level = 0;
   else
      this.level = parentNode.level + 1;
    
   if (parentNode)
   {
      // Inserting child at specific location, or appending to end?
      if( insertPos == null )
      {
         parentNode.addChild(this);
      }
      else
      {
         parentNode.insertChild(this, insertPos);
      }
   } 
 
   if (parentNode == null)
      this.treeRoot = this; 
   else
      this.treeRoot = parentNode.treeRoot;
    
   if(parentNode)
      this.treeDef = parentNode.treeDef;
  
   if (this.treeDef)
      this.treeDef.initObjectClass(this, signature);
}

sawtree.TreeNode.prototype.getRoot = function ()
{
   return this.treeRoot;
}

sawtree.TreeNode.prototype.isRoot = function ()
{
   return this.treeRoot == this;
}

sawtree.TreeNode.prototype.getProviderName = function ()
{
   return this.getAttributeValue("treeDataProvider");
}

sawtree.TreeNode.prototype.isSelectable = function ()
{
   var sel = this.getAttributeValue("selectable");
   if (sel && (sel == "true" || sel =="t"))
      return true;
   else 
      return false;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getOnClickHtml = function ()
{
   return " onclick='" + "sawtree.onClickHandler" + "(" + this.id + ", event)'";
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getOnDblClickHtml = function TN_getOnDblClickHtml()
{
   return " ondblclick='" + "sawtree.onDblClickHandler" + "(" + this.id + ", event)'";
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getTree = function TN_getTree ()
{
   if(this)
   {
      return this.treeDef;
   }
}


sawtree.TreeNode.prototype.getTreeDefinitionName = function ()
{
  if (this.htmlData)
      return this.treeDef.treeDefName;
   else
      return "";
}

/********************************************************************************************/
sawtree.TreeNode.prototype.isOpen = function TN_isOpen()
{
   return this.m_bIsOpen;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.isLastOpenedFolder = function TN_isLastOpen()
{
   return this.m_bIsLastOpenedFolder;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.isRendered = function TN_isRendered()
{
   return this.m_bIsRendered;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.isLoaded = function TN_isLoaded()
{
   return this.m_bIsLoaded;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getDisplayPath = function ()
{
   if (this.displayPath)
      return this.displayPath;
   else
      return this.getPath();
}

sawtree.TreeNode.prototype.getPath = function ()
{
   return this.path;
}

sawtree.TreeNode.prototype.getXPath = function ()
{
   return this.xpath;
}

sawtree.TreeNode.prototype.getName = function ()
{
   return this.name;
}

/********************************************************************************************/
sawtree.TreeNode.prototype.getSelectHtml = function ()
{
   if (this.m_bSelectable)
      return kmsgSelect;
   else
      return kmsgUnselect;
}
  //methods 

/********************************************************************************************/

/********************************************************************************************/
sawtree.TreeNode.prototype.redrawChildren = function ()
{
   var navObj = document.getElementById(this.getElementId());
   var childTag = this.getChildrenTag();
   var childObj = document.getElementById(childTag);
   if(childObj)
      childObj.innerHTML = this.drawInnerChildren(null);
      
   this.showChildren();

}
/********************************************************************************************/
sawtree.TreeNode.prototype.showChildren = function ()
{

   var folderChild = document.getElementById(this.getChildrenTag()); 
   var imgOpen = document.getElementById(this.getEleImageId());
   if (!this.isOpen()) 
   {
      imgOpen.src = this.iconImageSrc();

      if(folderChild)
         folderChild.style.display = "none";
   }
   else
   {
      imgOpen.src = this.iconImageSrc();
      if (folderChild && (this.isEmptyMsgDisplay() || this.getNumberChildren() > 0))
         folderChild.style.display = "block";
   }
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getChildrenTag = function TN_getChildrenTag ()
{
   return this.getType() + this.id + "cd";
}

sawtree.TreeNode.prototype.getNumberChildren = function ()
{
   return this.nChildren;
}

/********************************************************************************************/
sawtree.TreeNode.prototype.getID = function TN_getID()
{
  //define a .xID in all nodes (folders and items) if you want to PERVESTATE that
  //work when the tree changes. The value eXternal value must be unique for each
  //node and must node change when other nodes are added or removed
  //The value may be numeric or string, but cannot have the same char used in cookieCutter
  if (typeof this.xID != "undefined") 
    return this.xID
  else
    return this.id
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getElementId = function TN_getElementId ()
{
   return "item" + this.id;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getEleNodeId = function ()
{
   return this.getElementId() + "div1";
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getEleNameId = function TN_getEleNameId ()
{
   return this.getElementId() + "name";
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getEleImageSpan = function ()
{
   return this.getElementId() +"imgspan";
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getEleImageId = function TN_getEleImageId ()
{
   return this.getElementId() + "imag1";
}
/********************************************************************************************/
sawtree.TreeNode.prototype.getDisplayName = function TN_getDisplayName ()
{
   if (this.displayName == "")
      return this.name;
   else
      return this.displayName;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.iconImageSrc = function () {
   var img = "";
   if (this.isOpen() && this.isFolder())
      img = this.getAttributeValue("imgExpand");
  
   if (!img)
      img = this.getAttributeValue("img");
   
   if (img)
   {  
      img = img.toLowerCase();
      var srcPath = WebScriptMapGet(img);
      if (srcPath)
         return srcPath;
      else 
         return img;
   }
   else
      return WebScriptMapGet("defaultimage");
 }

/********************************************************************************************/
sawtree.TreeNode.prototype.isEmptyMsgDisplay = function()
{
   var display = this.getAttributeValue("displayEmpty");
   if (display != "false")
      return true;
   else 
      return false;
}

/********************************************************************************************/
sawtree.TreeNode.prototype.drawEmptyChild = function()
{
  var sHtml = ""; 
  
  if(!this.isLoaded())
  {
    sHtml = "<div class='emptyFolder' unselectable='on'>" + saw.kmsgTreeViewLoading + "</div>";
  }
  else if (this.isEmptyMsgDisplay())
  {
    sHtml = "<div class='emptyFolder' unselectable='on'>" + saw.kmsgTreeEmptyFolder + "</div>";
  }
  return sHtml;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.addChild = function TN_addChild(childNode) 
{ 
  this.children[this.nChildren] = childNode; 
  childNode.parentObj = this;
  this.nChildren++ 
  return childNode; 
}

/********************************************************************************************/
sawtree.TreeNode.prototype.insertChild = function TN_insertChild(childNode, pos)
{
   // Insert alphabetically?
   var i;
   if( pos == -1 )
   {
      for(i=0; i < this.nChildren; i++)
      {
         // Insert before any non-folder node
         if(( this.children[i].type == null ) ||
            ( this.children[i].type != "folder" ))
         {
            pos = i;
            break;
         }

         // RMc - 4th Oct 2006
         // #5556809 - Don't sort on case sensitivity, so force uppercase comparison
         if( childNode.name.toUpperCase() < this.children[i].name.toUpperCase() )
         {
            pos = i;
            break;
         }
      }

      // If pos is still -1 then append on the end
      if( pos == -1 )
      {
         pos = this.nChildren;
      }
   }

   // Can't insert beyond the end, so simply append
   if( pos >= this.nChildren )
   {
      return this.addChild( childNode );
   }


   // Insert node at specific location
   // Shuffle the other children down to make space for this new one
   for(i=this.nChildren; i>pos; i--)
   {
      this.children[i] = this.children[i-1];
   }
  
   this.children[pos] = childNode; 
   childNode.parentObj = this;
   this.nChildren++;

   return childNode;
}

/********************************************************************************************/
sawtree.TreeNode.prototype.isFolder = function TN_isFolder()
{
   return false;
}
/********************************************************************************************/
sawtree.TreeNode.prototype.renderObject = function TN_drawObject (insertAtObj) 
{ 
  var docW = "";
  var strBuf = new saw.StringBuffer();

  this.m_bIsRendered = true;
  
  var idParam = "id='" + this.getElementId() + "'";
  var tableId = "id='" + this.getElementId() + "table" + "'";
  var imgDisplay1 = " style='display:none'";
  
  var divId1 = "id='" + this.getEleNodeId()+ "'";
  var imgId1 = this.getEleImageId();
  var imgIdSpan = this.getEleImageSpan();
  var imgId2 = this.getElementId() + "img2";
  var imgIdLeft = this.getElementId() + "imgLeft";
  var nameId = this.getEleNameId();
  var bDraggable = this.getAttributeValue("draggable");
  var dragId = this.getTreeXmlId();
  var dragClass = this.getAttributeValue("dragClass");
  var treeXmlId = "xml" + this.getElementId();
  var class1 = " className='" + this.getAttributeValue("overClass") + "' ";
  var class2 = " className='" + this.getAttributeValue("normalClass") + "' ";
  
  if (bDraggable)
     this.setDragXml();
  
  if (bDraggable)
  {
   strBuf.append("<div ");
   strBuf.append("id='");
   strBuf.append(dragId);
   strBuf.append("' class='");
   strBuf.append(dragClass);
   strBuf.append("' draggable='true'");
   strBuf.append(" name='");
   strBuf.append(saw.encodeHTMLAttrValue(this.getDisplayName()));
   strBuf.append("' onMouseDown='");
   strBuf.append(this.getAttributeValue("onMouseDown"));
   strBuf.append("'");
   
   strBuf.append(" treeNode='");
   strBuf.append("true");
   strBuf.append("'");
   strBuf.append(" treeXmlId='");
   
   if (this.getDragXml())   //only add treeXmlId if it contains dragXml
      strBuf.append(dragId);
   
   strBuf.append("'");

   strBuf.append(" path='");
   strBuf.append(saw.encodeHTMLAttrValue(this.getPath()));
   strBuf.append("' ");
         
   strBuf.append(" viewType='sawd:")
   strBuf.append(this.getAttributeValue("viewType") + "' ");
   
   strBuf.append(" >");
 }

  if (this.isFolder())
   strBuf.append("<div " + idParam + " class='treeViewTable'" + " style='display:block; position:block;'>"); 
     
  if (this.level == 0)
  { 
      strBuf.append("<table " + "class='treeViewTable' " + tableId + ">");
      strBuf.append( "<tr><td>");
  }
  
  strBuf.append("<div "  + divId1 + " class='" + this.getAttributeValue("initClass") + "' " + this.getSelectHtml());
  var sclickOnFolder = "";
  
  sclickOnFolder = this.getOnClickHtml();

  var ondblclickMethod = this.getOndblclickMethod();
  if (this.getAttributeValue("onDblClickEval") || this.htmlData.onDblClickMethod)
     sclickOnFolder += " " + this.getOnDblClickHtml();

  strBuf.append(sclickOnFolder);
    
  strBuf.append(">");

  strBuf.append("<span class='cellPic' id='" + imgIdSpan + "'>");
  //left image is the + sign
  if (this.getAttributeValue("leftImageSrc"))
  {
      strBuf.append("<img class='image' id='" + imgId2 + "' src='" + this.getAttributeValue("leftImageSrc") + "' " + this.getSelectHtml() + ">"); 
  }

  
  var iconSrc = this.iconImageSrc();
      
  strBuf.append("<img class='image' id='" + imgId1 + "' src='" + iconSrc + "' " + this.getSelectHtml() +  "></span>"); 
   
  strBuf.append("<span class='TreeNode'>");
  

  
  strBuf.append("<span class='" + this.getAttributeValue("initClass") + "'");
  strBuf.append(" id='" + nameId + "' onMouseOver=\"");
  strBuf.append(class1 + "\"" + " onMouseOut=\"" + class2 + "\"" + " onmousedown=''");
  strBuf.append(this.getSelectHtml() + " title='" + saw.encodeHTMLAttrValue(this.getToolTip()) + "'>" + saw.encodeHTML(this.getDisplayName()));
  if ((this.getDictURL() != undefined) && (typeof(kViewDictionaryPrivilege) != "undefined"))
      strBuf.append("&nbsp;<a class='mdict' href='" + this.getDictURL() + "' target='_blank' title='" + kmsgViewMetadataDictionary + "' onclick='saw.stopEventPropagation(event)'><img style='padding-left:3px' align='absmiddle' src='" + WebScriptMapGet("common/dictionary.gif") + "' border='0'></a>");
  strBuf.append("</span></span></div>");

  var sHtml = "";
  sHtml = this.drawChildren(insertAtObj);
  strBuf.append(sHtml);

  if (this.level == 0)
  {   
      strBuf.append("</td></tr></table>");    
  }
  
  if (this.isFolder())
   strBuf.append("</div>");
   
  if (bDraggable)
   strBuf.append("</div>");
   
  return strBuf.toString();
} 

/********************************************************************************************/
sawtree.Item = function (name, type, parentObj, path, signature)
{
   var item = new sawtree.TreeNode();
   item.init(name, path, parentObj, signature)
   item.path = path;
   item.getType = function () {return "item";}
   return item;
}
/********************************************************************************************/
sawtree.SubjectItem = function SubjectItem (name, type, parentObj, path)
{
   var item = new sawtree.TreeNode();
   item.init (name, path, parentObj);
   item.path = path;
   item.onClickMethod = clickOnItemSubject;
   
   return item;
}

/********************************************************************************************/
sawtree.Folder = function Folder (name, type, parentObj, path, signature, insertPos) 
{
  var folder = new sawtree.TreeNode(); 
  folder.init(name, path, parentObj, signature, insertPos);
  folder.children = new Array();
  folder.path = path;
  folder.subType = "folder";
  folder.type = "folder";

  //html data
  folder.initClass = "folderNormal";
  folder.normalClass = "folderNormal";
  folder.overClass = "folderOver";
  
  folder.closeOnName = true; //if user clicks on the name of an expanded folder, it will not be close
   
  //folder methods
  folder.loadBranch = sawtree.loadBranch;
  folder.onClickMethod = null;
  folder.onDblClickMethod = null;
  folder.onClickMethodEval = null;// method in text format
  folder.isFolder = function (){   return true; }
  folder.getType = function () {return "folder";}
  
  return folder;
} 




/********************************************************************************************/

sawtree.TreeNode.prototype.getOnclickMethod = function()
{
   if (this.htmlData)
   {   
     var func = this.htmlData.getOnclickMethod();
     return func;
   }
   else
      return null;
}

sawtree.TreeNode.prototype.getOndblclickMethod = function()
{
   if (this.htmlData)
   {   
     var func = this.htmlData.getOndblclickMethod();
     return func;
   }
   else
      return null;
}

sawtree.TreeNode.prototype.getSubjectArea = function()
{
  var subjectAreaName = this.getRoot().getName();
  if (subjectAreaName)
    return subjectAreaName;
  else if (this.treeDef.subjectArea)
    return this.treeDef.subjectArea;
  else
    return "";
}

/********************************************************************************************/

sawtree.Folder.prototype.addChildren = function addChildren(listOfChildren) 
{ 
  this.children = listOfChildren 
  this.nChildren = listOfChildren.length
  for(i=0;i<this.nChildren;i++)
    this.children[i].parentObj = this
} 
/********************************************************************************************/

sawtree.Folder.prototype.getChild = function getChild (index)
{
   if (this.children == null || this.nChildren == 0)
      return null;
   else if (index >= 0 && index < this.nChildren)
      return this.children[index];
   else 
      return null;
}
/********************************************************************************************/

sawtree.Folder.prototype.writeFolderXml = function (sBuf, isNew)
{
   var i = 0;
   if(this.isNew() && isNew)
   {
      sBuf.append("<folder name=\"");
      sBuf.append(this.name);
      sBuf.append("\" path=\"");
      sBuf.append(this.path);
      sBuf.append("\"");
      if (isNew)
      {
         sBuf.append(" isNew=\"t\"");
      }
      
      sBuf.append(">");
      
      if (this.nChildren > 0)
      {
         sBuf.append("<children>");
         for (i=0; i< nChildren; ++i)
         {
            var obj = this.children[i];
            if (obj.isFolder())
               obj.writeFolderXml(sBuf, isNew);
         }
         sBuf.append("</children>");
      }
      sBuf.append("</folder>");
   }
}


sawtree.Folder.prototype.isFolder = function ()
{
   return true;
}

sawtree.Item.prototype.isFolder = function ()
{
   return false;
}

/********************************************************************************************/
   
sawtree.TreeNode.prototype.getNumberFolderChild = function ()
{
   var number = 0;
   var i;
   if(this.children)
   {
      for (i = 0; i < this.nChildren; ++i)
      {
         var child = this.children[i];
         if (child.isFolder())
            number++;
      }
   }
   return number;
}
   
/********************************************************************************************/

sawtree.TreeNode.prototype.drawChildren = function TN_drawChildren ()
{
   var sHtml = "";
   var strBuf = new saw.StringBuffer();
   var imgDisplay = "'display:none'";

   if (this.m_bIsOpen && (this.isEmptyMsgDisplay() || this.getNumberChildren() > 0))
      strBuf.append("<DIV class='nextLevelShown'"  + " id='" + this.getChildrenTag() + "'" + " unselectable='on' " + ">");
   else
      strBuf.append("<DIV class='nextLevelHidden'" + " id='" + this.getChildrenTag() + "'" + " unselectable='on' " + ">");
   
   if (this.drawEmptyChild == null)
   {
      strBuf.append("</div>");
      return strBuf;
   }
   
   strBuf.append(this.drawInnerChildren());

   strBuf.append("</div>");
   
   return strBuf;
}

/********************************************************************************************/

sawtree.TreeNode.prototype.insertObject = function ()
{

}


/********************************************************************************************/

sawtree.TreeNode.prototype.toggleFolder = function ()
{
   var openState = this.isOpen();
   if(this.isOpen())
      this.m_bIsOpen = false;
   else
      this.m_bIsOpen = true;
      
   var imgDisplay = "'display:none'";
   var imgOpen = document.getElementById(this.getEleImageId());
   var folderChild = document.getElementById(this.getChildrenTag()); 

   if (openState) 
   {
      imgOpen.src = this.iconImageSrc();
      if(folderChild)
         folderChild.style.display = "none";
   }
   else
   {
      imgOpen.src = this.iconImageSrc();
      if (folderChild && (this.isEmptyMsgDisplay() || this.getNumberChildren() > 0))
         folderChild.style.display = "block";

   }
}
/********************************************************************************************/

sawtree.TreeNode.prototype.drawInnerChildren = function TN_drawInnerChildren ()
{
   var sHtml = "";
   var strBuf = new saw.StringBuffer();
      
   if (this.nChildren == 0 || this.children == null)
      return this.drawEmptyChild();
   
   var i = 0;
   var obj = null;
   for (i = 0; i < this.nChildren; ++i)
   {
      obj = this.children[i];
      if(obj)
      {
         strBuf.append(obj.renderObject());   
      }
   }
   
   return strBuf;
}



//The list can contain either a Folder object or a sub list with the arguments for Item 

/********************************************************************************************/

sawtree.procXmlTreeData = function (data)
{
   sawtree.procXmlTree(data.getXML(), false);
}


sawtree.loadBranch = function (clickItem)
{
   var result;
   var array = new Array();
   var url =  "GetTreeBranchDataXml";
   var paramArray = new sawtree.Parameters();
   paramArray.addParam("BranchPath", clickItem.getPath());
   paramArray.addParam("BranchXPath", clickItem.getXPath());
   paramArray.addParam("elementId", clickItem.getID());
   paramArray.addParam("branchType", clickItem.getTreeType());
   paramArray.addParam("treeDef", clickItem.getTreeDefinitionName());
   paramArray.addParam("treeDataProvider", clickItem.getProviderName());
   paramArray.addParam("SubjectArea", clickItem.getSubjectArea());   
   paramArray.addParam("displayPath", clickItem.getDisplayPath());
   
   url += "&" + paramArray.toArgString();
   sawtree.sendAjaxReq(url, null, "GET", null, sawtree.procXmlTreeData);    
   return result;
}
/********************************************************************************************/

 

/********************************************************************************************/
//stores the items and folders 
sawtree.addItemTable = function (item)
{
  item.id = sawtree.nItems;
  sawtree.itemTable[sawtree.nItems] = item;
  sawtree.nItems++;
}
 
 
// Events 
// ********************************************************* 
 
 
sawtree.selectItem = function (itemId, sPath)
{
   var item = sawtree.findItem(itemId);   
   var lastClicked = item;
   if (sawtree.clickedItemId)
      lastClicked = sawtree.findItem(sawtree.clickedItemId);
   sawtree.clickedItemId = itemId;
   
   var browserId = 'idBrowser';   
    if (saw.browserId)
      browserId = saw.browserId;
         
 
   clickedItem(item.getEleNodeId(), sPath, lastClicked ? lastClicked.getAttributeValue("normalClass") : item.getAttributeValue("normalClass"), 'folderSelected', 'idBrowser', browserId);
      
}
 
 
sawtree.onClickHandler = function (itemId, event)
{
   var item = sawtree.findItem(itemId);   
   var clickedId = item.getElementId();
   
   if (item)
   {
      var browserId = 'idBrowser';
      var bWrite = item.getAttributeValue("writeAccess");
      
      var bAccessRequired = item.getAttributeValue("accessRequired");

      if (saw.browserId)
         browserId = saw.browserId;

      if (item.getAttributeValue("onClickEval"))
      {//eval the method
         eval (item.getAttributeValue("onClickEval"));
      }
      else
      {
         var onclickMethod = null;
         onclickMethod  = item.getOnclickMethod();
         if (item.htmlData.onClickMethod)
            item.htmlData.onClickMethod(itemId, event);
      }
      
      if (item.isSelectable() && (bAccessRequired != "true" || bWrite == "true") && item.isFolder())
      {
         sawtree.selectItem(itemId, item.getPath());    
      }
      
   }
   else
      sawtree.debug("ERROR:  In on Click Handler, Item Id " + itemId + " not found");
} 
 
sawtree.onDblClickHandler = function (itemId, event)
{
   var item = sawtree.findItem(itemId);   
   var clickedId = item.getElementId();
   
   if (item)
   {
      if (item.getAttributeValue("onDblClickEval"))
      {//eval the method

         eval (item.getAttributeValue("onDblClickEval"));
      }
      else
      {
         var ondblclickMethod = null;
         ondblclickMethod  = item.getOndblclickMethod();
         if (item.htmlData.onDblClickMethod)
            item.htmlData.onDblClickMethod(itemId, event);
      }
   }
   else
      sawtree.debug("ERROR:  In on DblClick Handler, Item Id " + itemId + " not found");
} 

sawtree.clickOnFolderHandler = function (item, event)
{
   sawtree.clickOnFolder(item, event);
}
 

/********************************************************************************************/

sawtree.findItemFromPath = function (path)
{
  for (var i=0; i < sawtree.nItems; ++i)
  {
     if (sawtree.itemTable[i].path == path)
       return sawtree.itemTable[i];
  }
  return null;
}

/********************************************************************************************/

sawtree.findItem = function (id)
{
   if (id >= 0 && id < sawtree.nItems)
      return sawtree.itemTable[id];
   else
   {
      sawtree.error("Id " + id + " not Found");
      return null;
   }  
}



/********************************************************************************************/
sawtree.createFolderNode = function (name, type, parentNode) 
{ 
  folder = new TreeNode(name, type, parentNode);
  return folder;
} 
 


/********************************************************************************************/




/********************************************************************************************/
function getElById(idVal) {
  if (document.getElementById != null)
    return document.getElementById(idVal)
  if (document.all != null)
    return document.all[idVal]
  
  sawtree.error("Problem getting element by id")
  return null
}

/********************************************************************************************/



sawtree.error = function (str)
{
   alert("ERROR: " + str);
}

/********************************************************************************************/

sawtree.Parameters = function ()
{
   this.array = null;
}

sawtree.Parameters.prototype.getArray = function ()
{
   return this.array;
}


sawtree.Parameters.prototype.toArgString = function ()
{
   var i = 0;
   var sBuf = new saw.StringBuffer ();
   for (i=0; i < this.array.length; ++i)
   {
      var pair = this.array[i];
      if(i != 0)
         sBuf.append("&");
         
      sBuf.append(pair.name);
      sBuf.append("=");
      sBuf.append(saw.encodeURIComponent(pair.value));
    }   
    
    return sBuf.toString();
}
      

sawtree.Parameters.prototype.addParam = function (name, value)
{
   if (!this.array)
      this.array = new Array();
      
   if (this.array)
   {
      var node = new sawtree.pair(name, value);
      this.array[this.array.length] = node;
   }  
}

sawtree.pair =function (name, value)
{
   this.name = name;
   this.value = value;
   return this;
} 

/********************************************************************************************/
sawtree.procXmlTree = function (xmlDoc, bInit)
{
   if (!xmlDoc)
   {
      return;
   }

   var treeElem = xmlDoc.selectSingleNode('//tree');
   var treeType;
   
   if (treeElem)
      treeType = treeElem.getAttribute("treeType");
   
   var i = 0;
         
   //clickItem.children = new array();
   var requestXml = xmlDoc.selectSingleNode('//request');
   if (requestXml == null)
   {
      return;
   }
   var id = requestXml.getAttribute('calledId');
   var clickItem = null;
   
   if (bInit == false)
      clickItem = sawtree.findItem(id);
   
   if (clickItem)
      clickItem.nChildren = 0;
   
   var treeBranch = treeElem.selectSingleNode('//treeBranch');
   
   sawtree.loadtree(treeBranch, clickItem, clickItem.getTree());
   
   if (clickItem)
   {

      if(treeBranch)
         clickItem.m_bIsLoaded = true;
         
      clickItem.redrawChildren();
   }
}




/********************************************************************************************/
sawtree.loadtree = function (treeData, parent, treeDef)
{
   var i = 0;
   //clickItem.children = new array();
   var bInitTree = false;
   var treeType = null;
   
   if (parent == null)
      bInitTree = true;
      
   if (treeData == null)
      return;

   for(i=0; i < treeData.childNodes.length; ++i)
   {
      if(treeData.childNodes[i].nodeType != 1) 
         continue;
      if(treeData.childNodes[i].nodeName != "treeNode")
         continue;
         
      var object = null;
      var item = treeData.childNodes[i];
      var itemType = item.getAttribute("itemType");
      var path = item.getAttribute("path");
      var displayName = item.getAttribute("displayName");
      var itemName = item.getAttribute("itemName");
      var desc = item.getAttribute("description");
      var signature = item.getAttribute("signature");
      var xpath = item.getAttribute("xpath");
      var dragXml = item.getAttribute("dragXml");
      var displayPath = item.getAttribute("displayPath");
      var dictURL = item.getAttribute("dictURL");

      object = treeDef.createNode (itemName, signature, itemType, path, parent);
       
      if (displayName != "")
      {
         object.displayName = displayName;
      }
      
      if (desc != "")
         object.description = desc;
         
      if (signature != "")
         object.signature = signature;
         
      if (xpath)
         object.xpath = xpath;
      else
         object.xpath = "";   
         
      if (dragXml)
      {
         object.dragXml = dragXml;
      }
      
      if (dictURL)
      {
         object.dictURL = dictURL;
      }
      
      
      if (displayPath)
         object.displayPath = displayPath;
      
      if (bInitTree)
      {
         parent = object;
         bInitTree = false;
         if(treeDef)
         {  
            treeDef.treeView.addTree(object);
            treeDef.initObjectClass(object, "rootClass");
            parent.treeDef = treeDef;
         }
      }   
      
      var j;
      for(j=0; j< item.childNodes.length;++j)
      {
         var node = item.childNodes[j];
         if (node.nodeName == "customData")
         {
            sawtree.parseCustomData(node, object);         
         }
         //process children
         if (itemType == "folder" && node.nodeName == "treeBranch")
         {   
            sawtree.loadtree(node, object, treeDef); 
            object.m_bIsLoaded = true;     
            if (object.getAttributeValue("initOpen") != "false")    
               object.m_bIsOpen = true;
         }
      }
   }  
   return parent;
}


//********************************************************************************************
sawtree.ClassDefinition  = function ClassDefintion ()
{
   this.name = "";
   this.parentClass = null;
   this.element = null;
   return this;
}

sawtree.ClassDefinition.prototype.init = function (typeName, itemType, treeType, parent, xmlElement)
{
   this.itemType = itemType;
   this.classType = typeName;
   this.treeType = treeType;
   this.parentClass = parent;
   this.element = xmlElement;
}

sawtree.ClassDefinition.prototype.getItemType = function ()
{
   return this.itemType;
}

sawtree.ClassDefinition.prototype.getClassType = function ()
{
   return this.classType;
}

sawtree.ClassDefinition.prototype.setXml = function (xmlElement)
{
   this.element = xmlElement;
}

sawtree.ClassDefinition.prototype.getOnclickMethod  = function ()
{

         var methodName = null;
         if (this.onClickMethod)
         {           
            return this.onClickMethod;
         }
         methodName = this.getAttributeValue("onClickMethodName");
         var func = null;
         if (methodName)
         {
            func = sawtree.getOnclickMethod(methodName);
            if (func)
            {  
               this.onClickMethod = func;
               return this.onClickMethod;
            }   
         }
         
         return null;

}

sawtree.ClassDefinition.prototype.getOndblclickMethod  = function ()
{

         var methodName = null;
         if (this.onDblClickMethod)
         {           
            return this.onDblClickMethod;
         }
         methodName = this.getAttributeValue("onDblClickMethodName");
         var func = null;
         if (methodName)
         {
            func = sawtree.getOndblclickMethod(methodName);
            if (func)
            {  
               this.onDblClickMethod = func;
               return this.onDblClickMethod;
            }   
         }
         
         return null;

}
/********************************************************************************************/


sawtree.ClassDefinition.prototype.getAttributeValue = function (attributeName)
{
   var value = null;
   
   value = this[attributeName];
   if (value)
      return value;
   
   if (this.element)
   {
      value = this.element.getAttribute(attributeName);
      if (value)
         return value;
   }

   if (this.parentClass)
      return this.parentClass.getAttributeValue (attributeName);
   else
      return "";
}

/********************************************************************************************/


sawtree.ClassDefinition.prototype.setAttribute = function (attributeName, attributeValue)
{
   if (attributeName)
      this[attributeName] = attributeValue;
}

/********************************************************************************************/
sawtree.ObjectDef = function ObjectDef ()
{
   this.typeList = new Object();

}

sawtree.ObjectDef.prototype.addClass = function (className, classDef)
{
   var classType = null;
   classType = this.typeList[className];
   if (classType == null)
   {
      this.typeList[className] = classDef;
   }
}

sawtree.ObjectDef.prototype.getClass = function (className)
{
   return this.typeList[className];
}

/********************************************************************************************/
sawtree.ObjectDef.prototype.addTypeDesc = function addTypeDesc (typeName, attributeName, attributeValue)
{
   var typeArray = null;
   typeArray = this.typeList[typeName];
   if(typeArray ==null)
   {
      typeArray = new Array();
      this.typeList[typeName] = typeArray;
   }
   addParam(typeArray, attributeName, attributeValue);
}

/********************************************************************************************/
sawtree.ObjectDef.prototype.addTypeAttr = function addTypeAttribute(typeName, typesElm, typeElm, attributeName, propName)
{
   var typesValue = typesElm.getAttribute(attributeName);
   var typeValue = typeElm.getAttribute(attributeName);
   
   if (propName == null)
      propName = attributeName;
      
   if(typeValue == null)
      typeValue = typesValue;
   if(typeValue)
      this.addTypeDesc(typeName, propName, typeValue);

}   
  


/********************************************************************************************/
sawtree.ObjectDef.prototype.parseObjectDef = function parseObjectDef(objectElm, objectDef)
{
   var imgExpand = objectElm.getAttribute("imgExpand");
   var img = objectElm.getAttribute("img"); //closed img
   var onclick = objectElm.getAttribute("onClickEval");
   var typesElm = objectElm.selectSingleNode("types");
   var onClickMethodName = objectElm.getAttribute("onClickMethodName");
   var ondblclick = objectElm.getAttribute("onDblClickEval");
   var onDblClickMethodName = objectElm.getAttribute("onDblClickMethodName");
   
   var i = 0;
   for (; i < typesElm.childNodes.length; ++i)
   {
      var type = typesElm.childNodes[i];
      var typeName = type.getAttribute("name");
      var treeType = type.getAttribute("type");
      objectDef.treeType = treeType;
      objectDef.addTypeAttr(typeName, objectElm, type, "imgExpand");  
      objectDef.addTypeAttr(typeName, objectElm, type, "img");  
      objectDef.addTypeAttr(typeName, objectElm, type, "onClickEval"); 
      objectDef.addTypeAttr(typeName, objectElm, type, "onClickMethodName");
      objectDef.addTypeAttr(typeName, objectElm, type, "onDblClickEval"); 
      objectDef.addTypeAttr(typeName, objectElm, type, "onDblClickMethodName");
      objectDef.addTypeAttr(typeName, objectElm, type, "treeDataProvider");
       
   }
   
}



if(typeof HTMLElement!="undefined" && !HTMLElement.prototype.insertAdjacentElement){
   HTMLElement.prototype.insertAdjacentElement = function (where,htmlNode)
   {
      switch (where){
      case 'beforeBegin':
         this.parentNode.insertBefore(htmlNode,this)
         break;
      case 'afterBegin':
         this.insertBefore(htmlNode,this.firstChild);
         break;
      case 'beforeEnd':
         this.appendChild(htmlNode);
         break;
      case 'afterEnd':
         if (this.nextSibling) 
            this.parentNode.insertBefore(htmlNode,this.nextSibling);
         else this.parentNode.appendChild(htmlNode);
         break;
      }
   }

   HTMLElement.prototype.insertAdjacentHTML = function(where,htmlString)
   {
      var doc = this.ownerDocument.createRange();
      doc.setStartBefore(this);
      var parsedHTML = doc.createContextualFragment(htmlString);
      this.insertAdjacentElement(where,parsedHTML)
   }
}

sawtree.handleServerError = function(tData, aFatal)
{
   alert('Unable to communicate with Oracle BI Presentation Services.  Please ensure you are still logged in and try again.');
}


sawtree.init();